# A review on non-Hermitian skin effect

Xiujuan Zhang1, †, Tian Zhang1, Ming-Hui Lu1,2,3,† and Yan-Feng Chen1,3 $I$ National Laboratory of Solid State Microstructures and Department of Materials Science and Engineering, Nanjing University, Nanjing 210093, China 2Jiangsu Key Laboratory of Artificial Functional Materials, Nanjing 210093, China 3Collaborative Innovation Center of Advanced Microstructures, Nanjing University, Nanjing 210093, China †Correspondence should be addressed to xiujuanzhang@nju.edu.cn (XJZ) or luminghui@nju.edu.cn (MHL).

# Abstract

The past decades have witnessed the flourishing of non-Hermitian physics in nonconservative systems, leading to unprecedented phenomena of unidirectional invisibility, enhanced sensitivity and more recently the novel topological features such as bulk Fermi arcs. Among them, growing efforts have been invested to an intriguing phenomenon, known as the non-Hermitian skin effect (NHSE). Here, we review the recent progress in this emerging field. By starting from the one-dimensional (1D) case, the fundamental concepts of NHSE, its minimal model, the physical meanings and consequences are elaborated in details. In particular, we discuss the NHSE enriched by lattice symmetries, which gives rise to unique non-Hermitian topological properties with revised bulk-boundary correspondence (BBC) and new definitions of topological invariants. Then we extend the discussions to two and higher dimensions, where dimensional surprises enable even more versatile NHSE phenomena. Extensions of NHSE assisted with extra degrees of freedom such as long-range coupling, pseudospins, magnetism, non-linearity and crystal defects are also reviewed. This is followed by the contemporary experimental progress for NHSE. Finally, we provide the outlooks to possible future directions and developments.

# 1. Introduction

The Hermiticity of a Hamiltonian guarantees its real eigenvalues and orthogonal eigenstates, which reflects the dynamics and shapes the physical reality of an isolated quantum system with conversed energy and probability. When encountering with non-conservative systems, however, gain/loss of the energy and probability leads to the breakdown of Hermiticity and requires non-Hermitian descriptions [1-3]. It has been shown the non-Hermitian considerations not only provide suitable descriptions to the open systems, but also bring novel physics and unprecedented phenomena and applications, as found in a variety of physical realms including open quantum systems [4], electronic systems with interactions [5], and classical systems with gain or loss [6-20]. For instance, mathematics suggests that the real eigenvalues do not necessarily rely on the Hermiticity, but can also be realized if the parity-time (PT) symmetry is satisfied as a form of pseudo-Hermiticity [1,3]. Such a mathematical prediction later on became a physical reality in non-Hermitian systems where balancing material gain and loss can lead to PT symmetry [9], associated with which, the eigenvalues of the non-Hermitian Hamiltonian are pure real. Once the balance between gain and loss is broken, the eigenvalues become complex and a transition point emerges in the parameter space, known as the exceptional point (EP). The EP signals the transition from the PT-symmetric phase to PT-broken phase. At the EP, both the eigenvalues and the eigenvectors coalesce, enabling exotic features such as unidirectional invisibility [11] and enhanced sensitivity [14].

On another front, due to the ubiquitous existence of non-Hermiticity in both naturally-occurring materials and artificial materials, its interaction with periodic/aperiodic lattices has inspired a surge of research. It was shown that by engineering a photonic crystal plate that radiates energy to its surrounding, a pair of EPs can be created in the band structures in the momentum space, connected to each other by an open-ended bulk Fermi arc [15], in direct contrast to the isofrequency contours with closed loops in Hermitian systems. This phenomenon was found to be closely related to the band topology interplayed with non-Hermiticity. Along this direction, extensive research effort has been made to explore novel non-Hermitian band physics and associated intriguing phenomena [21-25]. Therein, a particularly interesting branch has drawn great attention recently, known as the NHSE [26], which describes the phenomenon that driven by non-Hermiticity, eigenstates of a lattice with open boundaries exhibit localized behaviors, drastically different from the extended Bloch waves in Hermitian systems. This phenomenon can be dated back to late 1990s where Hatano and Nelson [27-28] proposed a 1D disordered tight-binding lattice with nearest-neighbor nonreciprocal hopping and showed that this nonreciprocity-induced non-Hermiticity can prevent Anderson localization, opening up a mobility region featuring unidirectional transport.

Very recently, similar phenomenon was also observed during the investigation of the topological properties of non-Hermitian systems. In Ref. [29], it was found driving by nonreciprocal gauging, the topological edge states become defective and only one of them is stable while the other is not and dynamically transits into the stable one. Eventually, two edge states become identical. Similar behaviors were later discussed in another literature where not only defective edge states were reported, but also all the bulk states were found to change from extended states to exponentially localized states only by a change of the boundary condition from periodic to open [30]. These phenomena are counterintuitive to the common rules in Hermitian topological systems and challenge the well-developed BBC, therefore igniting tremendous research interest. Some seminal works include revisiting the Hatano-Nelson (HN) model to realize versatile directional transports [31-35], interpreting NHSE from different points of view [36-48], developing new theories, methods and material designs to describe the NHSE-related topological properties and the associated non-Hermitian BBC [26,49-89], extending NHSE from simple 1D studies to two and higher dimensions [78,90-102], exploring novel NHSE features enriched by various degrees of freedom [103-120], and experimentally demonstrating the NHSE [114,117,121-130].

Following these progresses, in this review, we start with the introduction of NHSE in the minimal 1D HN model (without any symmetry), its theoretical and physical interpretations, then move to the non-Hermitian systems with symmetries where the interplay between band topology (enabled by various symmetries) and NHSE leads to re-defined BBC and novel non-Hermitian topological properties. We next turn our discussions to higher dimensions with a focus on the 2D systems where dimension surprisingly gives rise to even more interesting phenomena such as higher-order NHSE and non-Bloch PT symmetry breaking without threshold. This is followed by an exhibition of the NHSE enriched by various degrees of freedom, such as long-range coupling, pseudospins, magnetism, non-linearity and crystal defects. The limited experimental progresses will also be included. Finally, we provide the conclusions and our perspectives on future possible directions. Here, we mention that because the existing theories and methods for the studies of NSHE are mostly well-defined and well-established in one dimension while the other topics including NHSE in higher dimensions, carrying extra physical degrees of freedom, and the experimental demonstrations are still prosperously ongoing, our main focus will be on the 1D NHSE phenomena.

# 2. 1D NHSE

# 2.1 The HN model as a minimal model for NHSE

As discussed above, the HN model was originally proposed to study the non-Hermitian delocalization and later on was revisited for its unique unidirectional transports enabled by the newly identified NHSE. In this section, we introduce the fundamentals of the NHSE based on a clean HN model without disorder, where the Hamiltonian descriptions, the manifestation of the NHSE and its consequences on eigenstates are provided. The HN model is a single particle, spinless, prototypical 1D non-Hermitian lattice with nonreciprocal hopping, as schematically illustrated in Figure 1(a), where the left and right hopping is denoted respectively by $t + \gamma$ and $t -$  with $\gamma$ characterizing the strength of nonreciprocity and therefore the strength of nonHermiticity. Without considering the disorders and onsite energy potential, the Hamiltonian under periodic boundary condition (PBC) reads

$$
H _ { \mathrm { H N } } ( k ) = ( t + \gamma ) e ^ { i k } + ( t - \gamma ) e ^ { - i k } ,
$$

where $k$ represents the Bloch wave vector and the lattice constant is taken as 1 throughout this review unless specified otherwise. Figure 1(b) shows the single band structure when $k$ runs over the 1D Brillouin zone (BZ). As expected, in such a non-Hermitian system, the eigenenergy $E$ becomes complex, with the real part still symmetric with respect to $k$ while the imaginary part exhibiting an asymmetric property. In fact, this asymmetric property is nothing but an exact indicator of the nonreciprocal nature of the system, suggesting an asymmetric transport behavior. That is, the probability of the left hopping does not equal to that of the right hopping. In an extreme case where $t = \gamma$ , the system only allows for the left hopping while the right hopping is forbidden. Consequently, upon open boundary conditions (OBCs), particles accumulate toward the left boundary, as shown by the eigenmode distributions in Figure 1(c-d) for two exemplified cases with $t = \gamma = 1$ and $t = 1 , \gamma = 0 . 4$ . Because the accumulation and localization behaviors share a phenomenological similarity to the skin accumulation of an alternating AC electric current in a conductor, this non-Hermitian phenomenon is dubbed NHSE and the localized modes are referred to as skin modes [26].

![](images/bd17e46b2d02ff9cb918413e1389f88e36d03d266cb7938bac6d33fb0c4fa561.jpg)  
Figure 1. (a) The HN model. (b) The energy band under PBC. (c-d) Mode profiles of all the eigenstates under OBCs. The total number of sites (i.e., the chain length) is taken as $N = 3 0$ .

The NHSE profoundly changes the Bloch band theory. As discussed above, associated with NHSE, the eigenstates of the systems loss their extendedness in the Bloch scope and become exponentially localized to lattice boundary. Such an intriguing property calls for revisiting the band theory in non-Hermitian systems and therefore has inspired novel research especially on nonreciprocal band physics, such as non-Hermitian topological properties which will be discussed later. In addition to the significances on band physics, the nonreciprocity-induced non-Hermiticity also holds great promises for directional transports and beyond. To list a few, in Refs. [32,34], Longhi et al. proposed and analyzed the unique unidirectional and bidirectional transports by nonreciprocal gauging in HN chains. Using a similar technique, the same author also suggested a method for excitation transfer [35], providing a shortcut to the adiabatic process while the latter usually requires long device length and/or long evolution time. In another proposal, it has been shown that under the threading of an imaginary vector potential (which can be effectively realized by nonreciprocal gauging), the optical gradient force can be enhanced by an order of magnitude, offering novel methods for actuation of microscopic objects using optical forces [131].

# 2.2 Interpretations of NHSE

After introducing the NHSE and its basics phenomena, next, we review the theories and methods to interpret NHSE from different points of view. There are three typical theories. The first one considers the NHSE as the effect of imaginary gauge fields, commonly used in early interpretations of non-Hermitian delocalization and directional transports in HN models [27, 28, 31-35]. It is known that threaded by a real gauge field, the particles accumulate a nontrivial real phase factor along their trajectory, which contributes to interferences that eventually lead to unidirectional transport, as in quantum Hall effect [132] and its various classical analogues [133, 134]. In the case of imaginary gauge fields, however, the particles accumulate an imaginary phase factor along their trajectory, which, instead of contributing to interferences, reduces or increases the particles’ amplitudes along the direction in which they hop [31,131]. Essentially, this process can be physically understood as directional attenuation or amplification, which, upon OBCs, leads to exponential localizations as shown in Figure 1(c-d).

The second theory is related with the EPs. As discussed in the introduction section, the EPs refer to the singularities in non-Hermitian systems, appearing either in the parameter space [9] or the momentum space [15]. In these systems, the non-Hermiticity usually comes from the material gain and loss. It has been shown that at the EPs, both the eigenvalues and eigenvectors coalesce [1]. A regular EP represents the coalescence of two states [as schematically illustrated in Figure 2(a)], which generally induces a square root singularity, making it more sensitive to the parameter change compared to a Hermitian degenerate point and can be potentially used as a novel mechanism for sensors [14,135]. Higher-order EPs are coalescences of multiple states [see Figure 2(b)], carrying higher-order singularities, which make them even more sensitive than the first-order EPs [136].

![](images/d073129d04284b03908a820a31e6dfb745c7dcdddf709262c7dacea8769182a0.jpg)  
Figure 2. Sketches of (a) a regular and (b) a third-order EPs in gain/loss-induced two-level and three-level non-Hermitian systems. (c-d) Higher-order EPs emerging in the HN model with OBCs.

Contrary to the high sensitivity of EPs in the gain/loss-induced non-Hermitian systems, recent studies have shown that EPs in nonreciprocity-induced non-Hermitian systems have strong fingerprints that can effectively pervade over a wide parameter regime and are possibly associated with the emergence of NHSE [30,36]. Specifically, it was found that in nonreciprocity-induced non-Hermitian open systems, high-order EPs appear with algebraic multiplicities scaling with the system size, whereas the geometric multiplicities remain as 1, as depicted in Figure 2(c-d). This indicates that at the EPs, all the bulk states coalesce at one state, which was found exponentially localized at lattice boundary under OBCs, corresponding to the non-Hermitian skin mode. Interestingly, these multiple coalescences not only affect the eigenstates near the EPs, but also have a global effect on the entire eigen-spectrum, leading to an extensive amount of bulk states transiting into skin modes [see Figure 1(c-d)]. Only far from the EPs, the NHSE becomes less obvious, i.e., the localization length becomes longer and the eigenstates restore certain extendedness. The special EPs induced by nonreciprocity have recently been further investigated and found to exhibit novel behaviors such as the unique existence under OBCs [137] and vanishing threshold for PT phase transition in two dimensions [138]. These features typically cannot be observed in traditional non-Hermitian systems with gain and loss.

The third theory characterizing NHSE is based on the evaluation of the winding numbers of the eigenenergy. Studying topological phases of matter has been a hot research topic in condensed matter physics, whose interesting phenomena are generally enabled by the nontrivial topological properties of the wave functions, not the eigenenergy, of the occupied bands (or in classical wave systems the group of bands below a band gap) [139-142]. When extending the concept of topological phases of matter to non-Hermitian systems, one can immediately identify a novel type of topological number given solely by eigenenergy. That is, by phase-winding the eigenenergy, not the wave functions, of a non-Hermitian Hamiltonian over the BZ, a nontrivial winding number emerges, which constitutes a topological object unique to the non-Hermitian systems [143]. For instance, consider the HN model shown in Figure 1(a) and replot its energy band in Figure 1(b) in the complex plane, as presented in Figure 3(a). It is shown that the eigenenergy forms a closed loop, with the direction of $k$ -winding from $- \pi$ to $\pi$ indicated by the arrow. For any base point $E _ { b }$ inside the loop, one has a nonzero winding number following the definition [44]

$$
\begin{array} { r } { w : = \frac { 1 } { 2 \pi } \int _ { - \pi } ^ { \pi } \frac { d } { d k } \mathrm { a r g } [ H ( k ) - E _ { b } ] d k . } \end{array}
$$

Essentially,  gives the number of times the complex eigenenergy encircles the base point $E _ { b }$ . For the HN model shown in Figure 1(a), the eigenenergy encircles one time the base points inside its loop, as depicted in Figure 3(a). Taking the convention that clockwise (anticlockwise) circling gives negative (positive) winding number, one has $w = 1$ for the present example. As a comparison, the eigenenergy of the Hermitian counterpart is also plotted, which constitutes a straight line [see Figure 3(b)], corresponding to a vanishing winding number.

The topological interpretation of such a unique property of the complex eigenenergy in the nonHermitian systems is elucidated in the following. According to the conventional BBC, for each base point $E _ { b }$ , the nonzero winding number $w$ indicates $| w |$ independent edge states with energy $E _ { b }$ . Since $E _ { b }$ can be any point inside the loop of the eigenenergy of $H ( k )$ under PBC, there are an infinite number of $E _ { b }$ , indicating infinite edge states. These edge states were shown to be manifested in the semi-infinite truncations of the non-Hermitian systems with only one boundary [43,144]. Upon full OBCs, i.e., the left and right open boundaries appear in a pair, the condition for infinite edge states breaks down. While some of the eigenstates are forbidden due to the finite length, the spectrum under the semi-infinite condition still includes the spectrum under the full OBCs as the former is the extrapolation of the latter under $L \to \infty$ , where $L$ ( denotes the chain length [43]. As a result, the eigenstates under the full OBCs still preserve the behaviors of the edge states in the semi-infinite systems and are exponentially localized, corresponding to the nonHermitian skin modes. It should be pointed out that even though their emergence has topological origin as discussed, the skin modes are not topological [34,36,92]. In fact, the eigenenergy under full OBCs no longer forms any loops nor encircles any base points, but instead collapses to arcs [see Figure 3(c) for an example of the HN model under full OBCs]. Accordingly, the winding number under full OBCs is either zero or ill-defined [144]. Nevertheless, the well-defined, nonzero  under PBCs is still a valid indicator, associated with which, the NHSE always manifests under OBCs [43, 44].

Recently, the correspondence between the nonzero winding of the eigenenergy under PBCs and the emergence of non-Hermitian skin modes under OBCs was further explored and their relations were rigorously established [44], via a novel concept of the generalized Brillouin zone (GBZ) [26, 57, 70]. It has been noticed in multiple occasions that due to the presence of NHSE, the eigenspectrum of certain non-Hermitian systems under OBCs drastically deviates from that under PBCs [26, 49, 90]. To tackle this issue, the concept of GBZ was proposed in the scope of non-Bloch band theory [26]. This theory takes a complex wave vector $k ^ { \prime } = k - i \ln r$ (it is in this form for the sake of concise formulism, with $r$ some real values) to replace the initial real wave vector $k$ and defines the GBZ based on $k ^ { \prime }$ so that the non-Hermitian dynamics can be characterized as the nonBloch wave propagation governed by the new phase factor $\beta = e ^ { i k \prime } = r e ^ { i k }$ .

![](images/dbceeca1d88ec28c783775ee2229a1cb13887f6f1acd7138d5b1f03bfb6c14e9.jpg)  
Figure 3. Energy windings under PBC for (a) the HN model with $t = 1$ , $\gamma = 0 . 4$ and (b) its Hermitian counterpart. (c) The corresponding energy spectrum under OBC for the HN model in

(a). (d-f) BZ and GBZ, periodic- and open-boundary spectra, together with the eigenmode distributions, for several non-Hermitian models yielding different GBZs. (d-f) are reproduced with permissions from Ref. [44].

Compared to the usual BZ with the phase factor $e ^ { i k }$ that encloses a unit circle as $k$ winds from $- \pi$ to $\pi$ , the GBZ with $\beta$ in general does not equal to a unit cell as $r$ typically deviates from 1. The corresponding physical consequences are non-Bloch transports with directional amplifications or attenuations under OBCs, consistent with the NHSE features discussed above. Rigorous proof also indicates that while GBZ forms a closed loop similar to the conventional BZ, it exhibits completely different mathematical features. For example, the GBZ encloses the same number of zeros and poles for the Hamiltonian as holomorphic functions, such that they cancel each other [44]. This indicates no matter what base point is chosen, the eigenenergy of the Hamiltonian under GBZ winds to zero, which further suggests the trajectories of the eigenenergy under GBZ (or in other words the open-boundary spectrum of the Hamiltonian) should not form any closed loop, but instead should collapse into arcs or segments. This is consistent with the observations in the prototypical HN model under OBCs [see Figure 3(c)]. In Ref. [44], several examples that exhibit versatile NHSE phenomena yielding different GBZs were demonstrated, as adapted in Figure 3(df).

In addition to the relation between the nonzero energy winding under PBCs and the presence of skin modes under OBCs, the same work also suggested an interesting interpretation of the NHSE by establishing another connection stating that the nonzero winding and the NHSE have the common physical origin as the nonvanishing current through the system. If the current runs over a loop, upon truncations, the charge will start to accumulate to one end of the open system and form skin modes. If on the other hand the current runs on an arc or a segment, the winding over a closed domain (e.g., a BZ) generates zero net current and accordingly there will not be any charge accumulation upon truncations.

In the above discussions, we have reviewed three main theories that interpret the NHSE from both mathematical and physical points of view, which have provided comprehensive, consistent and complementary understanding on the NHSE. In particular, the understating on the relation between the nonzero winding of the eigenenergy of the non-Hermitian Hamiltonian under PBCs and the presence of NHSE under OBCs via the calculable GBZ technique has offered complete formulism and physical interpretation within a single theoretical scope and therefore become well-accepted, which recently has been generated to higher dimensions [102].

# 2.3 NHSE enriched by symmetries

A very important research realm for NHSE, in addition to its fundamental demonstrations, is the explorations of NHSE enriched by various symmetries. The above discussed prototypical HN model has no symmetry constraint, which already gives the interesting NHSE. Considering extra symmetries naturally brings new degrees of freedom that may interplay with the NHSE, leading to even more exciting physics and phenomena, such as the breakdown of the conventional BBC [26, 49, 57] and the defective edge states [29, 63, 145], as mentioned above and will be discussed in details in the following.

Topological phases of matter have been hot topics in condensed matter physics and their research interest is still growing, accompanying with the discoveries of novel topological phases, their robust transport behaviors and more excitingly the explorations of potential applications of the topological materials [133, 134, 146-148]. Among them, the crystalline (or lattice) symmetryinduced topological phases of matter in particular have attracted tremendous attention [149], especially in classical wave systems where artificial materials provide highly controllable and designable platforms for the realization of novel topological phases that are elusive or even absent in naturally-occurring materials [133, 134, 146-148]. The simplest example is the so-called SuSchrieffer-Heeger (SSH) model [150], which consists of spinless particles hopping on a 1D lattice with staggered intra- and inter-cell hopping, as sketched in Figure 4(a), where the hopping amplitudes are represented by $t _ { 1 }$ and $t _ { 2 }$ , respectively. The corresponding Hermitian Hamiltonian is written as

$$
H _ { \mathrm { S S H } } ( k ) = \binom { 0 } { t _ { 1 } + t _ { 2 } e ^ { i k } } \stackrel { t _ { 1 } + t _ { 2 } e ^ { - i k } } { 0 } \stackrel { \displaystyle } { \left. \right) } .
$$

This model contains two sublattices of A and $\mathrm { B }$ and therefore obeys the chiral symmetry, which presents a $Z _ { 2 }$ -type topology [61]. When the inter-cell hopping is stronger, i.e., $| t _ { 1 } | < | t _ { 2 } |$ , the system is topologically nontrivial and hosts zero-energy edge modes, one at each boundary under OBCs. When the intra-cell hopping is stronger, i.e., $| t _ { 1 } | > | t _ { 2 } |$ , the system goes into topologically trivial region. The topological transition occurs at exactly $| t _ { 1 } | = | t _ { 2 } |$ . Such topological properties can be identified either by tracing the energy gap-opening-closing-reopening process under PBCs [as exemplified in Figure 4(b-d)], or by searching for zero-energy edge modes under OBCs [see Figure 4(e), the red curve]. The identification of the topological phase diagram under PBCs predicts exactly the parameter regimes where the edge modes emerge under OBCs, and vice versa. This is the well-known BBC in Hermitian systems. Figure 4 (f-i) presents the mode profiles for some randomly selected eigenstates, where the extended bulk Bloch modes [see Figure 4(f)] and localized edge modes separate at the left and right chain boundaries [see Figure $4 ( \mathrm { g } \mathrm { - } \mathrm { i } ) ]$ are clearly distinguishable.

When non-Hermiticity is induced by considering nonreciprocal hopping, however, very different behaviors are observed. Some typical signatures include the localizations for an extensive number of bulk states, the breakdown of the conventional BBC and the defectiveness of the edge modes. Based on the above analyses for NHSE, it is expected that driven by the non-Hermiticity, the originally extended Bloch bulk modes become localized skin modes. More importantly, it has been noticed that the NHSE also affects the topological properties of the SSH model, leading to a breakdown of the conventional BBC, as firstly pointed out by Yao and Wang [26] and also corroborated by some earlier observations [29, 30]. They found that the band gap closing point identified under PBCs can no longer indicate the emergence of the zero-energy edge modes under OBCs. Instead, there is a large deviation between the open boundary spectra and the periodic boundary spectra, as illustrated in Figure 4(j-n) for an exemplified non-Hermitian SSH model with nonreciprocal hopping, whose non-Hermitian Hamiltonian reads

$$
H _ { \mathrm { N H - S S H } } ( k ) = \binom { 0 } { t _ { 1 } + ( t _ { 2 } + \gamma ) e ^ { i k } } + \stackrel { t _ { 1 } + ( t _ { 2 } - \gamma ) e ^ { - i k } } { 0 } \stackrel { } { } \mathrm { , }
$$

where the nonreciprocity is introduced on the inter-cell hopping and characterized by an offset $\gamma$ . The corresponding interesting behaviors of the bulk and zero-energy edge modes driven by the NHSE in such a system are presented in Figure 4(o-r), where the bulk states become skin modes localized around the left chain boundary while the edge states experience a transition from being separate at the two chain ends to becoming identical edge skin modes localized around the left chain end. The latter corresponds to the defectiveness of the edge states and will be discussed later. To establish a generalized BBC, dubbed non-Bloch BBC that is able to describe such nonHermitian topological systems, Yao and Wang [26] proposed the GBZ method and based on the GBZ, they successfully derived the topological phase transition points under OBCs, which were shown to be indeed quantitively different from that under PBCs, providing concrete evidence to the breakdown of Hermitian BBC in non-Hermitian systems. Subsequently, they proposed and evaluated the non-Hermitian winding number defined on and run over the GBZ, whose results faithfully determine the non-Hermitian topological edge states and hence establish the non-Bloch BBC, reminiscent of the Hermitian BBC where the topological invariants faithfully determine the emergence of the Hermitian edge states. Note that the winding number mentioned here is defined as the winding of the eigenstates over the GBZ [26], different from the winding number discussed above in Equation 2, which is defined as the winding of the eigenenergy over the conventional BZ [44].

![](images/8597f4e68003ec616d7181f51faa76db46bdcc3b6fab7164bc226ce1e19e2146.jpg)  
Figure 4. (a) The Hermitian SSH model, its energy spectra under (b-d) PBC and (e) OBC. (f-i)

Mode profiles for the bulk and edge states. $( \mathrm { j - r } )$ The same as (a-i), only for the non-Hermitian SSH model. The figures are adapted with permissions from Ref. [145].

As mentioned above, the NHSE not only leads to the breakdown of the conventional BBC, but also has nontrivial effects on the topological edge states. As shown in Figure 4(o-r), driven by the non-Hermiticity, both the bulk and edge states transit into non-Hermitian skin modes. However, different from the bulk skin modes that can be observed for any nonvanishing non-Hermiticity, the edge skin modes are only found when the non-Hermitian strength is large enough. This phenomenon was identified in a recent study [145], which showed that there exists a competition between the band topology protected by certain crystalline symmetry and the NHSE, leading to an unambiguous transition from symmetry dominance to non-Hermitian dominance. In the former, the edge states are distributed separately at the two edges of the open-boundary system, which are imposed by the crystalline symmetry (e.g., the chiral symmetry). In the latter where the nonHermiticity is strong enough, the NHSE triumphs over the protection of the crystalline symmetry and forces the edge states to transit into edge skin modes. Due to the defectiveness of the nonHermitian Hamiltonian, the resultant edge skin modes are also defective, i.e., they collapse into a single skin mode [29,145]. This is another interesting phenomenon enabled by the interplay between NHSE and symmetries.

In addition to the above discussions, Okuma et al. [43] also suggested another type of symmetryprotected skin effect, i.e., the $Z _ { 2 }$ NHSE, which was found to appear in the spinful systems that respect time-reversal symmetry. Similar to the quantum spin Hall effect, the time-reversal symmetry supplies a $Z _ { 2 }$ invariant that enables a pair of skin modes localized at the two ends of a non-Hermitian open chain. A canonical model was proposed by combining the HN model with its time-reversed partner. It is pointed out that because the $Z _ { 2 }$ NHSE is protected by the time-reversal symmetry, an infinitesimal symmetry-perturbation may break down the skin effect.

# 3. Higher-dimensional NHSE

With the flourishing of NHSE in 1D systems, it is nature to extend the related studies to two and higher dimensions, where the dimension surprisingly gives rise to versatile NHSE phenomena. In this section, we review the recent progress of NHSE in two and higher dimensions.

A direct extension of the HN model to two and higher dimensions is the simplest generalization. As schematically illustrated in Figure 5, higher dimensions give more freedom to control the nonreciprocity. For instance, if the nonreciprocity is only imposed along one direction, the NHSE leads to line and surface wave localizations respectively in two and three dimensions. If the nonreciprocity is imposed along more than one direction, 2D corner NHSE and 3D hinge and corner NHSE can be obtained, providing versatile wave manipulations.

![](images/dcbae8ca3bfac7037dffcfe619021c05835e3f19d8008169556ca28a2685d81c.jpg)

Figure 5. Higher dimensional extensions of the HN model. The orange shading schematically represents the distributions of the skin modes. Note that only the primary hopping is indicated for the sake of clarity.

In HN-like models, there is no symmetry constraint and hence all eigenstates are skin modes, i.e., the skin modes scale with $L ^ { d }$ where $L$ denotes the length of the finite lattice with OBCs and $d$ represents the dimension. When combined with symmetries, however, the symmetries impose restrictions on the hopping particles and accordingly the skin modes do not necessarily scale with $L ^ { d }$ , but instead exhibit versatile varieties. In Ref. [92], Lee et al. combined the nonreciprocity with chiral symmetry in a 2D square lattice consisting of four hopping sites in each unit cell [see Figure 6(a)]. The nonreciprocity is considered in both $x \cdot$ - and $y$ -directions with different threading, such that by manipulating the threading, the net nonreciprocity of the whole lattice can be skillfully controlled. It was shown that for a general threading, corner NHSE similar to that in a 2D HN model is observed, as shown in Figure 6(b). If the nonreciprocity is destructively canceled along the $x$ -direction, NHSE only appears in the $y .$ -direction [see Figure 6(c)]. When the nonreciprocity is destructively canceled along both directions and hence the net nonreciprocity vanishes, counterintuitively, corner skin modes were again observed under full OBCs, which were found to be the consequences of the 1D topological edge states experiencing local nonreciprocity [see Figure 6(d) for the topological edge states and Figure 6(e) for the corner skin modes]. Considering their origin, these skin modes are dubbed hybrid skin-topological modes and they scale with $L$ ( [92]. The similar results have been also generated to three dimensions. Later, a more comprehensive understating on the skin-topological properties was reported [98], providing analytical deductions and interpretations for different localization behaviors.

Following this direction, others non-Hermitian lattices yielding NHSE were also proposed. For example, taking the Benalcazar-Bernevig-Hughes model [151] as the extended Hermitian Hamiltonian, the resultant non-Hermitian model enables an interesting NHSE that hosts corner skin modes scaling with $L$ while accompanying $\mathcal { O } ( L ^ { 2 } )$ extended bulk modes [95]. In a later work [99], based on the model in Ref. [95] and by adding on-site disorders, an energy-asymmetrical NHSE can be obtained where in some regions in the complex energy plane, the corner NHSE manifests while in other regions, the NHSE disappears due to the disorder localizations.

Note that the terminology higher-order NHSE has been widely, which, however, refers to different NHSE phenomena in different literature and does not have a universal definition. Hence, to avoid possible confusion, in this review, we do not refer to higher-order NHSE for any particular NHSE phenomenon, but simply use it as a terminology indicating the general NHSE phenomena in higher dimensions.

![](images/184498105804ea1a694aaeb29d56224e9358dd5315bfa218904afd40e4fab0d7.jpg)

Figure 6. (a) The 2D tight-binding model, where NHSE is manifested as (b) corner skin modes for nonreciprocity in both directions and as (c) edge skin modes when nonreciprocity is canceled in the $x$ -direction. (d-e) Hybrid skin-topological modes with nonreciprocity canceled in both directions. The figures are reproduced with permissions from Ref. [92].

Another phenomenon enabled by NHSE, known as the non-Bloch PT symmetry, has been briefly discussed in Section 2.2, associated with the nonreciprocity-induced EPs. Generating to higher dimensions, novel features arise simply due to the increasing of spatial dimensions [138]. Specially, it was shown that the non-Bloch PT phase breaking in two and higher dimensions universally approaches to zero as the system size increases, whereas the Bloch PT phase breaking and the 1D non-Bloch PT phase breaking generally have nonzero thresholds. Although a physical explanation is still lacking, this interesting phenomenon suggests rich and unexpected interplay among PT symmetry, NHSE, and spatial dimensions.

When versatile NHSE phenomena have been reported, the contemporary theories for higherdimensional NHSE have been also explored. In Ref. [102], Zhang et al. proposed a theorem that relates the emergence of NHSE in two and higher dimensions to the periodic-boundary spectrum of the non-Hermitian Hamiltonian by requiring the latter to cover a finite area on the complex energy plane, similar to the NHSE theorem in 1D systems where the periodic-boundary spectrum is required to form loops (see detailed discussions in Section 2.2). While providing a phenomenological indication to the higher-order NHSE, this theorem does not give a rigorous formulism as that in 1D case using the GBZ technique. In fact, it has been shown that the GBZ theory cannot be generated to higher dimensions [44]. An alternative was proposed via numerical calculating the topological invariant based on the eigenstates under OBCs [53]. When consistent with GBZ theory in 1D cases, this method can be generalized to two dimensions. However, it has been only applied to topological systems and its applicability to higher-order NHSE phenomena still requires verification. In Ref. [95], the Wess-Zumino term was introduced to specifically explain the emergence of the corner skin modes in the non-Hermitian lattice under study. Overall, it is fair to say that the theories for higher-order NHSE are somewhat case by case, leaving the general formulism still an open question.

# 4. NHSE with extra physical degrees of freedom

In addition to generating the NHSE phenomena to higher dimensions, another research trend is to explore the interplay between NHSE and extra physical degrees of freedom such as long-range coupling, pseudospins, magnetism, non-linearity, crystal defects, etc., which will be reviewed in this section.

![](images/07032645369bff9d0ddd9d4cb861d0bdf49e27b346750f899155bf68e813621c.jpg)  
Figure 7. (a) Twisted windings in the HN model with long-range coupling and its bipolar skin effect. (b-d) Various windings by manipulating the long-range couplings. The figures are reproduced with permissions from Refs. [108, 117].

First, we show how the long-range coupling can be a powerful tool to enrich the nonreciprocity and accordingly lead to versatile NHSE phenomena. In Ref. [53], Song et al. proposed that by introducing long-range coupling, a bipolar NHSE can be obtained where the skin modes appear either at the left or the right chain end depending on its eigenenergy. In a later work [117], the HN model with long-range coupling was experimentally realized to demonstrate the bipolar NHSE in an acoustic system. It was shown that this effect is essentially due to the generating of two regions of opposite eigenenergy windings [117], as illustrated in Figure 7(a). A more comprehensive study even suggested it is possible to generate arbitrary windings by manipulating the long-range couplings (see Figure 7(b-d) for adapted examples from Ref. [108]).

Besides the long-range coupling, there are many other ingredients that make the NHSE flavorful. For instance, a recent study exploited the pseudospin degrees of freedom emulated by whispergallery modes in ring waveguides and realized the spin-dependent NHSE in a passive system [114]. Another work identified that the magnetic fields can suppress the NHSE, leading to the OnsagerLifshitz quantization rule persisting in the long-wavelength limit regardless of the NHSE [152]. Meanwhile, a real-to-complex transition of the energy spectra was found to appear in such a system upon the spontaneous breaking of an underlying mirror-time reversal symmetry, a reminiscent of the PT symmetry and its phase transition. More recently, the non-linearity has also been introduced to the studies of NHSE, which was shown to be able to realize NHSE with symmetric couplings [109] or to dynamically modify the structures of the skin modes [153]. Another interesting exploration of NHSE with flavor is with the assistance of crystal defects such as dislocations [116,118] and disclinations [111]. It was shown that driven by the carefully-designed nonreciprocity, an extensive number of eigenstates become localized at the vicinity of the dislocations or disclinations, exhibiting novel features for NHSE that does not require and can be disentangled from the open boundaries. Note that due to the geometric nature of the crystal defects, the defect-induced NHSE phenomena are unique in two and higher dimensions.

# 5. Experimental progress

Accompanying the theoretical developments, the recent years have also witnessed the experimental progress for NHSE. In this section, we review the experimental platforms, various ways to introduce nonreciprocity, the experimental characterizations of the NHSE, as well as the demonstrated special and unique NHSE features and phenomena.

![](images/c84933dbc98745b456e3a9a35eea92777a422e91a3522c28c781bf1623c408cb.jpg)  
Figure 8. (a) The experimental set-up of optical fiber loops. (b) Time-modulation to realize nonreciprocal couplings. (c) A schematic light funnel proposed using the NHSE, whose experimental measurements are shown in (d-f) for different input of light. The figures are reproduced with permissions from Ref. [121].

As one of the earliest experimental demonstrations of the NHSE, Ref. [121] used a 1D photonic lattice consisting of optical fiber loops, whose set-up is shown in Figure 8(a). The amplitudes of the left- and right-moving photons are controlled by a time-modulation on their hopping paths via a beamsplitter that essentially mediates the hopping strength between the lattice sites [see Figure 8(b)]. When the mediation is neutral, the photonic lattice behaves as an SSH lattice supporting topological edge states. When the mediation becomes biased, the system becomes nonreciprocal and the NHSE is manifested, with all eigenstates exponentially localized at the interface terminated by another photonic lattice with opposite mediation. Based on such an NHSE phenomenon, the authors proposed a light funnel that can efficiently guide any incident light toward the designed interface, irrespective of the shape and input positions of the incidence, as schematically illustrated in Figure 8(c) and experimentally verified in Figure 8(d-f).

The similar time-modulating technique for photons was also used in the field of non-unitary quantum-walks to realize the nonreciprocal hopping [see Figure 9(a)] and hence the 1D NHSE [122]. In the same work, the interesting non-Hermitian BBC was further demonstrated by directly observing the non-Hermitian topological edge states and their agreement with the non-Bloch topological invariants defined on the GBZ.

Another implementation of the nonreciprocity-induced non-Hermiticity in photonics was facilitated in the scope of synthetic dimensions, where the multiple frequency modes in a ring resonator are treated as a 1D synthetic dimension [108]. The couplings among the modes are controlled by the amplitude and phase modulations, with the nonreciprocity induced by detuned modulations. Using this set-up, the authors have demonstrated arbitrary non-Hermitian windings in a HN-like model with long-range couplings, as discussed in Section 4. The set-up for this design is illustrated in Figure 9(b) for the ring resonator (left panel) and the synthetic frequency dimension (right panel).

On another front, the electric circuits have been proven to be very powerful in mimicking the tightbinding models, as the industrially well-refined electric components are capable of accommodate exact and almost arbitrary control of hopping [128]. By using electric circuits, the NHSE has been demonstrated not only in 1D systems [123, 124, 126], but also in two and higher dimensions [128, 130]. The corresponding set-ups for these electric circuits are displayed in Figure 9(c-f). Due to this high controllability, electric circuits have become the most popular experimental platform for the NHSE studies. A recent preprint even suggested electric circuits can mimic a strongly correlated non-Hermitian many-body system which supports a non-Hermitian many-body skin effect [127].

While lacking the flexibility of versatile modulations and coupling control, the acoustic community has also skillfully proposed feasible techniques to experimentally observe and explore novel NHSE phenomena. For example, in Ref. [117], the acoustic nonreciprocity was realized with a directional amplifier enabled by a DC power supply, whose set-up is shown in Figure 9(g). Using this set-up, the twisted non-Hermitian windings and bipolar skin effect were reported, as discussed in Section 4.

![](images/cb48b2c569e8eb622b2dcd13ee5c96c0bd71ba9724a71696194b03034c2718f5.jpg)  
Figure 9. Experimental set-ups for NHSE demonstrations in various physical platforms, including

(a) quantum-walks, (b) photonic synthetic dimensions, (c-f) 1D, 2D and 3D electric circuits, as well as (g) acoustic cavities equipped with electrical amplifiers. These figures are reproduced with permissions from Ref. [108, 117, 122, 123, 126, 128].

Other experimental studies for NHSE also include clever designs of nonreciprocity in mechanics [125, 154-156] and recently in ultracold atoms [129]. In the former examples, active mechanical components, such as local control loops with biased strain-dependent forces [125, 154, 155] and odd micropolar materials constructed with piezoelectric elements whose cycle feed induces asymmetric bending and shearing [156], were used to break reciprocity. Accordingly, interesting active and non-Hermitian features were reported, such as odd elasticity [157] and mechanical robots [155]. In the ultracold-atom experiment, the nonreciprocity was obtained by a momentumlattice engineering method which generates a synthetic magnetic flux via the Raman or Bragg transitions. In this path, the condensed atoms experience a laser-induced dissipation process, while in the opposite path, the Raman-Bragg coupling is turned off and no dissipation occurs, hence generating nonreciprocity [129]. NHSE phenomenon was accordingly observed.

In addition to the above discussed active and additive control of couplings, a recent experimental work suggested that in a complete reciprocal system with time-reversal symmetry, it is also possible to realize NHSE [114]. As shown in Figure 10(a), the system was implemented in a 2D ring-resonator design, which supports decoupled clockwise and anticlockwise modes. A carefully designed loss configuration was introduced to the link rings, such that for each of the whispergallery modes, the propagation is nonreciprocal [see Figure 10(b) for the illustration in the $x \cdot$ - direction and similar analyses can be performed in the $y .$ -direction]. But for the entire lattice, it maintains the reciprocity, i.e., for each clockwise mode propagation, there is always a timereversed anticlockwise partner. With this design, the authors demonstrated a $Z _ { 2 }$ NHSE in two dimensions, accompanying clockwise and anticlockwise corner skin modes localized at opposite geometric corners [see Figure 10(c), compared with the Hermitian counterpart in Figure 10(d)]. This was also dubbed pseudospin-dependent NHSE, as discussed in Section 4. It is pointed out that although this work was implemented in acoustics but can be readily extended to photonics where the optical resonator waveguides have been proven to be mature material platforms.

![](images/b3d8244dfea8f9f41e08183567c0201e1c1d3027192c44468392d54887531a81.jpg)

Figure 10. A unit cell of the 2D reciprocal lattice. The green areas represent the lossy domains. (b) Nonreciprocal propagation for each clockwise or anticlockwise mode. (c) Higher-order NHSE manifested as pseudospin-dependent corner skin modes. (d) The Hermitian case as the comparison. (a, c-d) are reproduced from Ref. [114].

# 6. Conclusions and outlooks

To summarize, we have reviewed the recent developments of NHSE, by illustrating in details the minimal model, the fundamental theories and physics, its interplay with symmetries, extensions to higher dimensions, the enrichment with various degrees of freedom, as well as the experimental progress. We believe such a comprehensive, informative and timely review on this fast-growing filed will not only provide hands-on practice for junior researchers, but also give rich perspectives for NHSE-related experienced researchers.

The directions to move forward could potentially rest on looking for novel NHSE phenomena in two and higher dimensions, especially enriched by various crystalline symmetries including both point-group and space-group symmetries, while the latter might require extra effort to realize nonreciprocity. Therein, topology as a flavorful ingredient for NHSE may bring even more exotic non-Hermitian physics and phenomena. Explorations on nonreciprocity-induced PT symmetry, mirror-time symmetry [152] and related exceptional features also fall into this category, which may facilitate the understanding of NHSE in higher dimensions and inspire new research that is unique to higher dimensions. Other topics such as incorporating various physical degrees of freedom including active components (which already have been widely explored), gauging control, synthetic features, etc., exploring other experimental platforms for both nonreciprocal and reciprocal realizations of NHSE, are also possible directions.

Conclusively, while many of the reviewed results, for the most part, have contributed to the understanding of basic physics and can only be categorized in terms of academic research or proofs of concepts, based on the unconventional ways various particles are manipulated, there have been already many convincing suggestions to potential applications such as unidirectional amplifiers [158], high-efficient energy harvesting via an edge burst [159] and autonomous mechanical robots [155]. With these visions, one can only look forward to unprecedented routes and possibilities for technologies that take advantage of the novel non-Hermitian and nonreciprocal physics.

# References

[1] Bender C M, Boettcher S. Real spectra in non-Hermitian Hamiltonians having PT symmetry.   
Phys Rev Lett. 1998;80(24):5243.   
[2] Bender C M, Boettcher S, Meisinger P N. PT-symmetric quantum mechanics. J Math Phys.   
1999;40(5):2201-2229.   
[3] Bender C M, Brody D C, Jones H F. Complex extension of quantum mechanics. Phys Rev Lett.   
2002;89(27):270401.   
[4] Rotter I. A non-Hermitian Hamilton operator and the physics of open quantum systems. J Phys A: Math Theor. 2009;42(15):153001.   
[5] Shen H, Fu L. Quantum oscillation from in-gap states and a non-hermitian landau level problem.   
Phys Rev Lett. 2018;121(2):026403.   
[6] Makris K G, El-Ganainy R, Christodoulides D N, et al. Beam dynamics in PT symmetric optical lattices. Phys Rev Lett. 2008;100(10):103904.   
[7] Klaiman S, Günther U, Moiseyev N. Visualization of branch points in PT-symmetric waveguides. Phys Rev Lett. 2008;101(8):080402.   
[8] Longhi S. Bloch oscillations in complex crystals with PT symmetry. Phys Rev Lett.   
2009;103(12):123601.   
[9] Rüter C E, Makris K G, El-Ganainy R, et al. Observation of parity–time symmetry in optics.   
Nat Phys. 2010;6(3):192-195.   
[10] Regensburger A, Bersch C, Miri M A, et al. Parity–time synthetic photonic lattices. Nature.   
2012;488(7410):167-171.   
[11] Feng L, Xu Y L, Fegadolli W S, et al. Experimental demonstration of a unidirectional reflectionless parity-time metamaterial at optical frequencies. Nat Mater. 2013;12(2):108-113. [12] Malzard S, Poli C, Schomerus H. Topologically protected defect states in open photonic systems with non-Hermitian charge-conjugation and parity-time symmetry. Phys Rev Lett. 2015;115(20):200402.   
[13] Zhen B, Hsu C W, Igarashi Y, et al. Spawning rings of exceptional points out of Dirac cones. Nature. 2015;525(7569):354-358.   
[14] Chen W, Kaya Özdemir Ş, Zhao G, et al. Exceptional points enhance sensing in an optical microcavity. Nature. 2017;548(7666):192-196.   
[15] Zhou H, Peng C, Yoon Y, et al. Observation of bulk Fermi arc and polarization half charge from paired exceptional points. Science. 2018;359(6379):1009-1012.   
[16] Ding K, Ma G, Zhang Z Q, et al. Experimental demonstration of an anisotropic exceptional point. Phys Rev Lett. 2018;121(8):085702.   
[17] Tang W, Jiang X, Ding K, et al. Exceptional nexus with a hybrid topological invariant. Science. 2020;370(6520):1077-1080.   
[18] Zhang Z, Qiao X, Midya B, et al. Tunable topological charge vortex microlaser. Science. 2020;368(6492):760-763.   
[19] Ji Z, Liu W, Krylyuk S, et al. Photocurrent detection of the orbital angular momentum of light. Science. 2020;368(6492):763-767.   
[20] Rivero J D H, Pan M, Makris K G, et al. Non-Hermiticity-governed active photonic resonances. Phys Rev Lett. 2021;126(16):163901.   
[21] Martinez Alvarez, V. M., Barrios Vargas, J. E., Berdakin, M., Foa Torres, L. E. F. Topological states of non-Hermitian systems. Eur Phys J Spec Top. 2018;227(12):1295-1308.   
[22] Ashida Y, Gong Z, Ueda M. Non-hermitian physics. Adv Phys. 2020;69(3):249-435. [23] Wang H, Zhang X, Hua J, et al. Topological physics of non-Hermitian optics and photonics:a review. J Opt. 2021;23:123001.   
[24] Bergholtz, E. J., Budich, J. C., Kunst, F. K. Exceptional topology of non-Hermitian systems. Rev Mod Phys. 2021;93(1):015005.   
[25] Ding K, Fang C, Ma G. Non-Hermitian Topology and Exceptional-Point Geometries. arXiv preprint arXiv:2204.11601, 2022.   
[26] Yao, S, Wang, Z. Edge states and topological invariants of non-Hermitian systems. Phys. Rev. Lett. 2018;121:086803.   
[27] Hatano N, Nelson D R. Localization transitions in non-Hermitian quantum mechanics. Phys Rev Lett. 1996;77(3):570.   
[28] Hatano N, Nelson D R. Vortex pinning and non-Hermitian quantum mechanics. Phys Rev B. 1997;56(14):8651.   
[29] Lee T E. Anomalous edge state in a non-Hermitian lattice. Phys Rev Lett. 2016;116(13):133903.   
[30] Xiong Y. Why does bulk boundary correspondence fail in some non-hermitian topological models. J Phys Commun. 2018;2(3):035043.   
[31] Longhi S, Gatti D, Valle G D. Robust light transport in non-Hermitian photonic lattices. Sci Rep. 2015;5(1):1-12.   
[32] Longhi S, Gatti D, Della Valle G. Non-Hermitian transparency and one-way transport in lowdimensional lattices by an imaginary gauge field. Phys Rev B. 2015;92(9):094204.   
[33] Longhi S. Tight-binding lattices with an oscillating imaginary gauge field. Phys Rev A. 2016;94(2):022102.   
[34] Longhi S. Non-Hermitian bidirectional robust transport. Phys Rev B. 2017;95(1):014201.

[35] Longhi S. Nonadiabatic robust excitation transfer assisted by an imaginary gauge field. Phys Rev A. 2017;95(6):062122.

[36] Alvarez V M M, Vargas J E B, Torres L E F F. Non-Hermitian robust edge states in one dimension:Anomalous localization and eigenspace condensation at exceptional points. Phys Rev B. 2018;97(12):121401.   
[37] McDonald A, Pereg-Barnea T, Clerk A A. Phase-dependent chiral transport and effective non-Hermitian dynamics in a bosonic Kitaev-Majorana chain. Phys Rev X. 2018;8(4):041031. [38] Lee, C. H., Thomale, R. Anatomy of skin modes and topology in non-Hermitian systems. Phys Rev B. 2019;99(20):201103.   
[39] Longhi, S. Probing non-Hermitian skin effect and non-Bloch phase transitions. Phys Rev Res. 2019;1(2):023013.   
[40] Song, F., Yao, S., Wang, Z. Non-Hermitian skin effect and chiral damping in open quantum systems. Phys Rev Lett. 2019;123(17):170401.   
[41] Schomerus, H. Nonreciprocal response theory of non-Hermitian mechanical metamaterials: Response phase transition from the skin effect of zero modes. Phys Rev Res. 2020;2(1):013058. [42] Borgnia, D. S., Kruchkov, A. J., Slager, R. J. Non-Hermitian boundary modes and topology. Phys Rev Lett. 2020;124(5):056802.   
[43] Okuma, N., Kawabata, K., Shiozaki, K., Sato, M. Topological origin of non-Hermitian skin effects. Phys Rev Lett. 2020;124(8):086801.   
[44] Zhang, K., Yang, Z., Fang, C. Correspondence between winding numbers and skin modes in non-Hermitian systems. Phys Rev Lett. 2020;125(12):126402.   
[45] Longhi, S. Unraveling the non-Hermitian skin effect in dissipative systems. Phys Rev B. 2020;102(20):201103. [46] Okuma, N., Sato, M. Quantum anomaly, non-Hermitian skin effects, and entanglement entropy in open systems. Phys Rev B. 2021;103(8):085428.   
[47] Longhi, S. Non-Hermitian skin effect beyond the tight-binding models. Phys Rev B. 2021;104(12):125109.   
[48] Yokomizo, K., Murakami, S. Scaling rule for the critical non-Hermitian skin effect. Phys Rev B. 2021;104(16):165117.   
[49] Kunst F K, Edvardsson E, Budich J C, et al. Biorthogonal bulk-boundary correspondence in non-Hermitian systems. Phys Rev Lett. 2018;121(2):026808.   
[50] Wang, B. X., Zhao, C. Y. Topological phonon polaritons in one-dimensional non-Hermitian silicon carbide nanoparticle chains. Phys Rev B. 2018;98(16):165435.   
[51] Kohei Kawabata, Ken Shiozaki, Masahito Ueda. Anomalous helical edge states in a nonHermitian Chern insulator. Phys Rev B. 2018;98(16):165148.   
[52] Jin L, Song Z. Bulk-boundary correspondence in a non-Hermitian system in one dimension with chiral inversion symmetry. Phys Rev B. 2019;99(8):081103.   
[53] Song F, Yao S, Wang Z. Non-Hermitian topological invariants in real space. Phys Rev Lett. 2019;123(24):246801.   
[54] Edvardsson E, Kunst F K, Bergholtz E J. Non-Hermitian extensions of higher-order topological phases and their biorthogonal bulk-boundary correspondence. Phys Rev B. 2019;99(8):081302.   
[55] Kunst F K, Dwivedi V. Non-Hermitian systems and topology: A transfer-matrix perspective. Phys Rev B. 2019;99(24):245116.   
[56] Longhi S. Topological phase transition in non-Hermitian quasicrystals. Phys Rev Lett. 2019;122(23):237601. [57] Yokomizo K, Murakami S. Non-bloch band theory of non-hermitian systems. Phys Rev Lett. 2019;123(6):066404.   
[58] Ge Z Y, Zhang Y R, Liu T, et al. Topological band theory for non-Hermitian systems from the Dirac equation. Phys Rev B. 2019;100(5):054105.   
[59] Jiang H, Lang L J, Yang C, et al. Interplay of non-Hermitian skin effects and Anderson localization in nonreciprocal quasiperiodic lattices. Phys Rev B. 2019;100(5):054301.   
[60] Imura K I, Takane Y. Generalized bulk-edge correspondence for non-Hermitian topological systems. Phys Rev B. 2019;100(16):165430.   
[61] Kawabata K, Shiozaki K, Ueda M, et al. Symmetry and topology in non-Hermitian physics. Phys Rev X. 2019;9(4):041015.   
[62] Lee J Y, Ahn J, Zhou H, et al. Topological correspondence between Hermitian and nonHermitian systems: Anomalous dynamics. Phys Rev Lett. 2019;123(20):206404.   
[63] Wang X R, Guo C X, Kou S P. Defective edge states and number-anomalous bulk-boundary correspondence in non-Hermitian topological systems. Phys Rev B. 2020;101(12):121116. [64] Zhu X, Wang H, Gupta S K, et al. Photonic non-Hermitian skin effect and non-Bloch bulkboundary correspondence. Phys Rev Res. 2020;2(1):013280.   
[65] Zeng Q B, Yang Y B, Lü R. Topological phases in one-dimensional nonreciprocal superlattices. Phys Rev B. 2020;101(12):125418.   
[66] Yoshida T, Mizoguchi T, Hatsugai Y. Mirror skin effect and its electric circuit simulation. Phys Rev Res. 2020;2(2):022062.   
[67] Mandal S, Banerjee R, Ostrovskaya E A, et al. Nonreciprocal transport of exciton polaritons in a non-Hermitian chain. Phys Rev Lett. 2020;125(12):123902.   
[68] Li L, Lee C H, Mu S, et al. Critical non-Hermitian skin effect. Nat Commun. 2020;11(1):1-8. [69] Gao P, Willatzen M, Christensen J. Anomalous topological edge states in non-Hermitian piezophononic media. Phys Rev Lett. 2020;125(20):206402.   
[70] Yang Z, Zhang K, Fang C, et al. Non-hermitian bulk-boundary correspondence and auxiliary generalized brillouin zone theory. Phys Rev Lett. 2020;125(22):226402.   
[71] Yoshida T. Real-space dynamical mean field theory study of non-Hermitian skin effect for correlated systems: Analysis based on pseudospectrum. Phys Rev B. 2021;103(12):125145. [72] Xu K, Zhang X, Luo K, et al. Coexistence of topological edge states and skin effects in the non-Hermitian Su-Schrieffer-Heeger model with long-range nonreciprocal hopping in topoelectric realizations. Phys Rev B. 2021;103(12):125411.   
[73] Claes J, Hughes T L. Skin effect and winding number in disordered non-Hermitian systems. Phys Rev B. 2021;103(14):L140201.   
[74] Okuma N, Sato M. Non-hermitian skin effects in hermitian correlated or disordered systems: Quantities sensitive or insensitive to boundary effects and pseudo-quantum-number. Phys Rev Lett. 2021;126(17):176601.   
[75] Kawabata K, Shiozaki K, Ryu S. Topological field theory of non-hermitian systems. Phys Rev Lett. 2021;126(21):216405.   
[76] Yu L W, Deng D L. Unsupervised learning of non-Hermitian topological phases. Phys Rev Lett. 2021;126(24):240402.   
[77] Roccati F. Non-Hermitian skin effect as an impurity problem. Phys Rev A. 2021;104(2):022215.   
[78] Zhong J, Wang K, Park Y, et al. Nontrivial point-gap topology and non-Hermitian skin effect in photonic crystals. Phys Rev B. 2021;104(12):125416. [79] Guo C X, Liu C H, Zhao X M, et al. Exact solution of non-hermitian systems with generalized boundary conditions: Size-dependent boundary effect and fragility of the skin effect. Phys Rev Lett. 2021;127(11):116801.   
[80] Mao L, Deng T, Zhang P. Boundary condition independence of non-Hermitian Hamiltonian dynamics. Phys Rev B. 2021;104(12):125435.   
[81] Alsallom F, Herviou L, Yazyev O V, et al. Fate of the non-Hermitian skin effect in manybody fermionic systems. arXiv preprint arXiv:2110.13164, 2021.   
[82] Yan Q, Chen H, Yang Y. Non-Hermitian skin effect and delocalized edge states in photonic crystals with anomalous parity-time symmetry. arXiv preprint arXiv:2111.08213, 2021. [83] Guo S, Dong C, Zhang F, et al. Theoretical Prediction of Non-Hermitian Skin Effect in Ultracold Atom Systems. arXiv preprint arXiv:2111.04220, 2021.   
[84] Zhou L, Li H, Yi W, et al. Engineering Non-Hermitian Skin Effect with Band Topology in Ultracold Gases. arXiv preprint arXiv:2111.04196, 2021.   
[85] Cai X. Boundary-dependent self-dualities, winding numbers, and asymmetrical localization in non-Hermitian aperiodic one-dimensional models. Phys Rev B. 2021;103(1):014201. [86] Li H, Cui X, Yi W. Non-Hermitian skin effect in a spin-orbit-coupled Bose-Einstein condensate. arXiv preprint arXiv:2201.01580, 2022.   
[87] Mandal S, Banerjee R, Liew T C H. From the topological spin-Hall effect to the nonHermitian skin effect in an elliptical micropillar chain. ACS Photonics. 2022;9(2):527-539. [88] Xiao Y X, Chan C T. Topology in non-Hermitian Chern insulators with skin effect. Phys Rev B. 2022;105(7):075128.   
[89] Li L, Teo W X, Mu S, et al. Direction reversal of non-Hermitian skin effect via coherent coupling. arXiv preprint arXiv:2203.07400, 2022. [90] Yao S, Song F, Wang Z. Non-hermitian chern bands. Phys Rev Lett. 2018;121(13):136802. [91] Wang H, Ruan J, Zhang H. Non-Hermitian nodal-line semimetals with an anomalous bulkboundary correspondence. Phys Rev B. 2019;99(7):075130.   
[92] Lee C H, Li L, Gong J. Hybrid higher-order skin-topological modes in nonreciprocal systems. Phys Rev Lett. 2019;123(1):016805.   
[93] Li L, Lee C H, Gong J. Topological switch for non-Hermitian skin effect in cold-atom systems with loss. Phys Rev Lett. 2020;124(25):250402.   
[94] Scheibner C, Irvine W T M, Vitelli V. Non-Hermitian band topology and skin modes in active elastic media. Phys Rev Lett. 2020;125(11):118001.   
[95] Kawabata K, Sato M, Shiozaki K. Higher-order non-Hermitian skin effect. Phys Rev B. 2020;102(20):205118.   
[96] Okugawa R, Takahashi R, Yokomizo K. Second-order topological non-Hermitian skin effects. Phys Rev B. 2020;102(24):241202.   
[97] Song Y, Liu W, Zheng L, et al. Two-dimensional non-Hermitian skin effect in a synthetic photonic lattice. Phys Rev Appl. 2020;14(6):064076.   
[98] Fu Y, Hu J, Wan S. Non-Hermitian second-order skin and topological modes. Phys Rev B. 2021;103(4):045420.   
[99] Kim K M, Park M J. Disorder-driven phase transition in the second-order non-Hermitian skin effect. Phys Rev B. 2021;104(12):L121101.   
[100] Yang X, Cao Y, Zhai Y. Non-Hermitian Weyl semimetals: Non-Hermitian skin effect and non-Bloch bulk–boundary correspondence. Chin Phys B. 2022;31(1):010308.   
[101] Zhu W, Gong J. Hybrid skin-topological modes without asymmetric couplings. arXiv preprint arXiv:2203.03284, 2022. [102] Zhang K, Yang Z, Fang C. Universal non-Hermitian skin effect in two and higher dimensions. Nat Commun. 2022;13(1):1-7.   
[103] Okuma N, Sato M. Topological phase transition driven by infinitesimal instability: Majorana fermions in non-hermitian spintronics. Phys Rev Lett. 2019;123(9):097701.   
[104] Zhang X, Gong J. Non-Hermitian Floquet topological phases: Exceptional points, coalescent edge modes, and the skin effect. Phys Rev B. 2020;101(4):045415.   
[105] Longhi, S. Non-bloch-band collapse and chiral zener tunneling. Phys Rev Lett. 2020;124(6):066602.   
[106] Longhi, S. Stochastic non-Hermitian skin effect. Opt Lett. 2020;45(18):5250-5253. [107] Yi Y, Yang Z. Non-Hermitian skin modes induced by on-site dissipations and chiral tunneling effect. Phys Rev Lett. 2020;125(18):186802.   
[108] Wang K, Dutt A, Yang K Y, et al. Generating arbitrary topological windings of a nonHermitian band. Science. 2021;371(6535):1240-1245.   
[109] Xu X, Xu H, Mandal S, et al. Interaction-induced double-sided skin effect in an excitonpolariton system. Phys Rev B. 2021;103(23):235306.   
[110] Lin Z, Ding L, Ke S, et al. Steering non-Hermitian skin modes by synthetic gauge fields in optical ring resonators. Opt Lett. 2021;46(15):3512-3515.   
[111] Sun X Q, Zhu P, Hughes T L. Geometric response and disclination-induced skin effects in non-Hermitian systems. Phys Rev Lett. 2021;127(6):066401.   
[112] Yuce C. Nonlinear non-Hermitian skin effect. Phys Lett A. 2021;408:127484.   
[113] Liu Y, Zeng Y, Li L, et al. Exact solution of the single impurity problem in nonreciprocal lattices: Impurity-induced size-dependent non-Hermitian skin effect. Phys Rev B. 2021;104(8):085401. [114] Zhang X, Tian Y, Jiang J H, et al. Observation of higher-order non-Hermitian skin effect.   
Nat Commun. 2021;12(1):1-8. [115] Deng K, Flebus B. Non-Hermitian skin effect in magnetic systems. arXiv preprint arXiv:2109.01711, 2021.   
[116] Schindler F, Prem A. Dislocation non-Hermitian skin effect. Phys Rev B. 2021;104(16):L161106.   
[117] Zhang L, Yang Y, Ge Y, et al. Acoustic non-Hermitian skin effect from twisted winding topology. Nat Commun. 2021;12(1):1-7.   
[118] Bhargava B A, Fulga I C, Van Den Brink J, et al. Non-Hermitian skin effect of dislocations and its topological origin. Phys Rev B. 2021;104(24):L241402.   
[119] Peng Y, Jie J, Yu D, et al. Manipulating non-Hermitian skin effect via electric fields. arXiv preprint arXiv:2201.10318, 2022.   
[120] Wang Q, Zhu C, Wang Y, et al. Amplification of quantum signals by the non-Hermitian skin effect. arXiv preprint arXiv:2202.10727, 2022.   
[121] Weidemann S, Kremer M, Helbig T, et al. Topological funneling of light. Science. 2020;368(6488):311-314.   
[122] Xiao L, Deng T, Wang K, et al. Non-Hermitian bulk–boundary correspondence in quantum dynamics. Nat Phys. 2020;16(7):761-766.   
[123] Helbig T, Hofmann T, Imhof S, et al. Generalized bulk–boundary correspondence in nonHermitian topolectrical circuits. Nat Phys. 2020;16(7):747-750.   
[124] Hofmann T, Helbig T, Schindler F, et al. Reciprocal skin effect and its realization in a topolectrical circuit. Phys Rev Res. 2020;2(2):023265. [125] Ghatak A, Brandenbourger M, Van Wezel J, et al. Observation of non-Hermitian topology and its bulk–edge correspondence in an active mechanical metamaterial. Proc Natl Acad Sci. 2020;117(47):29561-29568.   
[126] Liu S, Shao R, Ma S, et al. Non-Hermitian skin effect in a non-Hermitian electrical circuit. Research. 2021;2021.   
[127] Zhang W, Di F, Yuan H, et al. Observation of non-Hermitian many-body skin effects in Hilbert space. arXiv preprint arXiv:2109.08334, 2021.   
[128] Zou D, Chen T, He W, et al. Observation of hybrid higher-order skin-topological effect in non-Hermitian topolectrical circuits. Nat Commun. 2021;12(1):1-11.   
[129] Liang Q, Xie D, Dong Z, et al. Observation of Non-Hermitian Skin Effect and Topology in Ultracold Atoms. arXiv preprint arXiv:2201.09478, 2022.   
[130] Shang C, Liu S, Shao R, et al. Experimental identification of the second-order non-Hermitian skin effect with physics-graph-informed machine learning. arXiv preprint arXiv:2203.00484, 2022. [131] Descheemaeker L, Ginis V, Viaene S, et al. Optical force enhancement using an imaginary vector potential for photons. Phys Rev Lett. 2017;119(13):137402.   
[132] Haldane F D M. Model for a quantum Hall effect without Landau levels: Condensed-matter realization of the" parity anomaly". Phys Rev Lett. 1988;61(18):2015.   
[133] Lu L, Joannopoulos J D, Soljačić M. Topological photonics. Nat Photonics. 2014;8(11):821- 829.   
[134] Zhang X, Xiao M, Cheng Y, et al. Topological sound. Commun Phys. 2018;1(1):1-13. [135] Miri M A, Alu A. Exceptional points in optics and photonics. Science. 2019;363(6422):49eaar7709. [136] Hodaei H, Hassan A U, Wittek S, et al. Enhanced sensitivity at higher-order exceptional points. Nature. 2017;548(7666):187-191.   
[137] Xiao L, Deng T, Wang K, et al. Observation of non-Bloch parity-time symmetry and exceptional points. Phys Rev Lett. 2021;126(23):230402.   
[138] Song F, Wang H Y, Wang Z. Non-Bloch PT symmetry breaking: Universal threshold and dimensional surprise. arXiv preprint arXiv:2102.02230, 2021.   
[139] Hasan M Z, Kane C L. Colloquium: topological insulators. Rev Mod Phys. 2010;82(4):3045. [140] Qi X L, Zhang S C. Topological insulators and superconductors. Rev Mod Phys. 2011;83(4):1057.   
[141] Chiu C K, Teo J C Y, Schnyder A P, et al. Classification of topological quantum matter with symmetries. Rev Mod Phys. 2016;88(3):035005.   
[142] Armitage N P, Mele E J, Vishwanath A. Weyl and Dirac semimetals in three-dimensional solids. Rev Mod Phys. 2018;90(1):015001.   
[143] Shen H, Zhen B, Fu L. Topological band theory for non-Hermitian Hamiltonians. Phys Rev Lett. 2018;120(14):146402.   
[144] Gong Z, Ashida Y, Kawabata K, et al. Topological phases of non-Hermitian systems. Phys Rev X. 2018;8(3):031079.   
[145] Cheng J, Zhang X, Lu M H, et al. Competition between band topology and non-Hermiticity. Phys Rev B. 2022;105(9):094103.   
[146] Ma G, Xiao M, Chan C T. Topological phases in acoustic and mechanical systems. Nat Rev Phys. 2019;1(4):281-294.   
[147] Ozawa T, Price H M, Amo A, et al. Topological photonics. Rev Mod Phys. 2019;91(1):015006. [148] Xie B, Wang H X, Zhang X, et al. Higher-order band topology. Nat Rev Phys. 2021;3(7):520-532.   
[149] Fu L. Topological crystalline insulators. Phys Rev Lett. 2011;106(10):106802.   
[150] Su W P, Schrieffer J R, Heeger A J. Solitons in polyacetylene. Phys Rev Lett. 1979;42(25):1698.   
[151] Benalcazar W A, Bernevig B A, Hughes T L. Quantized electric multipole insulators. Science. 2017;357(6346):61-66.   
[152] Shao K, Geng H, Chen W, et al. Interplay between Non-Hermitian Skin Effect and Magnetic Field: Skin Modes Suppression, Onsager Quantization and MT Phase Transition. arXiv preprint arXiv:2111.04412, 2021.   
[153] Ezawa M. Dynamical nonlinear higher-order non-Hermitian skin effects and topological trap-skin phase. Phys Rev B. 2022;105(12):125421.   
[154] Brandenbourger M, Locsin X, Lerner E, et al. Non-reciprocal robotic metamaterials. Nat Commun. 2019;10(1):1-8.   
[155] Brandenbourger M, Scheibner C, Veenstra J, et al. Active impact and locomotion in robotic matter with nonlinear work cycles. arXiv preprint arXiv:2108.08837, 2021.   
[156] Chen Y, Li X, Scheibner C, et al. Realization of active metamaterials with odd micropolar elasticity. Nat Commun. 2021;12(1):1-12.   
[157] Scheibner C, Souslov A, Banerjee D, et al. Odd elasticity. Nat Phys. 2020;16(4):475-480. [158] McDonald A, Clerk A A. Exponentially-enhanced quantum sensing with non-Hermitian lattice dynamics. Nat Commun. 2020;11(1):1-12.   
[159] Xue W T, Hu Y M, Song F, et al. Non-Hermitian Edge Burst. Phys Rev Lett. 2022;128(12):120401.